#! /usr/bin/env python
# -*- coding: utf-8 -*-

"""
Usage:

from encrypt import Encryption

enc = Encryption()
enc.setKey('your encryption key here')

enc.encode('your string to encrypt')
enc.decode('your string to decrypt')
"""

import sys
import base64
import time
import hashlib

try:
	from Crypto.Cipher import AES
except Exception, e:
	print "Is PyCrypto installed?"
	sys.exit(1)

class Encryption():
	
	def __init__(self, parent=None):
		self.key = ""
	
	def setKey(self, key):
		self.key = hashlib.sha1(key).hexdigest()[:32]
		
	def rpad(self, string, multiplier=16):
		length = len(string)
		rest = length % multiplier
		if rest != 0:
			topad = multiplier - rest
			totlen = length + topad
			string = "{:<{total_length}}".format(string, total_length=totlen)
		return string
	
	def safe_b64encode(self, string):
		data = base64.b64encode(string)
		data = data.replace("+", "-")
		data = data.replace("/", "_")
		data = data.replace("=", "")
		return data
	
	def safe_b64decode(self, string):
		string = string.replace("-", "+")
		string = string.replace("_", "/")
		mod4 = len(string) % 4
		if mod4:
			string += "===="[mod4:]
		return base64.b64decode(string)
	
	def encode(self, string):
		if len(string) == 0:
			return False
		string = self.rpad(string)
		AES.keysize = 128
		iv = ""
		cryptobj = AES.new(key=self.key, mode=AES.MODE_ECB, IV=iv)
		return self.safe_b64encode(cryptobj.encrypt(string)).rstrip().lstrip()
	
	def decode(self, string):
		if len(string) == 0:
			return False
		string = self.safe_b64decode(string)
		string = self.rpad(string)
		iv = ""
		cryptobj = AES.new(key=self.key, mode=AES.MODE_ECB, IV=iv)
		return cryptobj.decrypt(string).rstrip().lstrip()
