<?php

/**
 * Usage:
 * Encryption::setKey("write your string here");
 * Encryption::encode("My text to encrypt");
 * Encryption::decode("My text to decrypt");
 * */

class Encryption {
    
    private static $skey = "";
    
    public static function setKey($key) {
        self::$skey = substr(sha1($key), 0, 32);
    }

    private static function safe_b64encode($string) {
        $data = base64_encode($string);
        $data = str_replace(array('+','/','='),array('-','_',''),$data);
        return $data;
    }

    private static function safe_b64decode($string) {
        $data = str_replace(array('-','_'),array('+','/'),$string);
        $mod4 = strlen($data) % 4;
        if ($mod4) {
            $data .= substr('====', $mod4);
        }
        return base64_decode($data);
    }

    public static function encode($value){ 
        if (empty($value)) {
            return false;
        }
        $iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_ECB);
        $iv = "";
        $crypttext = mcrypt_encrypt(MCRYPT_RIJNDAEL_128, self::$skey, $value, MCRYPT_MODE_ECB, $iv);
        return trim(self::safe_b64encode($crypttext)); 
    }

    public static function decode($value){
        if (empty($value)) {
            return false;
        }
        $crypttext = self::safe_b64decode($value); 
        $iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_ECB);
        $iv = "";
        $decrypttext = mcrypt_decrypt(MCRYPT_RIJNDAEL_128, self::$skey, $crypttext, MCRYPT_MODE_ECB, $iv);
        return trim($decrypttext);
    }
    
}

?>
