#!/usr/bin/env python

import os
import sys
import shutil
import subprocess

class UpdateMysql(object):
	
	def __init__(self):
		self.filedata = None
		self.libmysql = "/var/lib/mysql"
		self.db_backup_file = "/root/mysql_backup.sql"
		self.mysql50_rpms = ["mysql", "mysql-server"]
		self.mysql55_rpms = ["mysql55", "mysql55-server", "mysql55-libs", "mysqlclient15"]
	
	def notifyUser(self):
		print "Upgrade from stock MySQL 5.0 to IUS MySQL 5.5 (Ensim 10.x)"
		print "----------------------------------------------------------"
		txt = "Before running this upgrade, make sure you have installed the stock RHEL/CentOS MySQL 5.0, "
		txt += "excluded the stock MySQL5.5 packages and the IUS Repository installed. If not certain, cancel.\n"
		txt += "type [yes] if you understood my note\n"
		txt += "type [no] if you don't want to take this risk\n"
		txt += "I AM NOT TAKING ANY RESPONSIBILITY FOR ANY DAMAGE THIS SCRIPT CAUSES. USAGE AT OWN RISK!"
		print txt
		while True:
			resp = raw_input("What is your answer? [yes/no] ")
			if str(resp) == "yes":
				return
			elif str(resp) == "no":
				raise Exception("User not sure. Aborting.")
			else:
				print "Common. Yes or No, try again... ;)"
	
	def stopMysql(self):
		print "Stopping database server..."
		proc = subprocess.Popen("/etc/init.d/mysqld stop", shell=True)
		proc.wait()
		if proc.returncode != 0:
			raise Exception("Ups. database server cannot be stopped.")
	
	def backupNeededFiles(self):
		print "Backing up mysql config..."
		shutil.copy("/etc/my.cnf", "/etc/my.cnf.50")
		print "Backing up mysql_init_app..."
		shutil.copy("/etc/init.d/mysqld_app_init", "/etc/init.d/mysqld_app_init.50")
		print "Backing up all databases..."
		if os.path.isfile(self.db_backup_file):
			ans = False
			while ans == False:
				resp = raw_input("Database backup found. Do it again? [y/N] ")
				if str(resp) == "y":
					ans = True
				elif str(resp) == "n" or str(resp) == "":
					print "Database update cancelled."
					return
		print "if asked for a password, enter the mysql root password"
		proc = subprocess.Popen("mysqldump --all-databases -p > "+self.db_backup_file, shell=True)
		proc.wait()
		if proc.returncode != 0:
			raise Exception("Ups. could not backup database.")
	
	def loadDatabaseList(self):
		print "Finding symlinks in database directory..."
		symlinks = []
		dir_list = os.listdir(self.libmysql)
		for dbfile in dir_list:
			dbfile = self.libmysql+"/"+dbfile
			if not os.path.islink(dbfile):
				continue
			symlinks.append({
				"symlink": dbfile,
				"db": os.readlink(dbfile)
			})
		self.filedata = symlinks
	
	def unlinkFiles(self):
		print "Unlinking files..."
		for symlink in self.filedata:
			print "Unlink: "+symlink["symlink"]
			os.unlink(symlink["symlink"])
	
	def relinkFiles(self):
		print "Relinking files..."
		for symlink in self.filedata:
			new_symlink = symlink["symlink"].replace("-", "@002d")
			print "Relink: "+new_symlink
			os.symlink(symlink['db'], new_symlink)
	
	def removeMysql50(self):
		print "Removing MySQL 5.0..."
		proc = subprocess.Popen("rpm -e --allmatches --nodeps "+" ".join(self.mysql50_rpms), shell=True)
		proc.wait()
		if proc.returncode != 0:
			ans = False
			while not ans:
				resp = raw_input("There was a problem with at least one package. Continue? [y/N] ")
				if str(resp) == "y":
					ans = True
				elif str(resp) == "n" or str(resp) == "":
					raise Exception("Upgrade cancelled.")
	
	def installMysql55(self, ):
		print "Installing MySQL 5.5..."
		proc = subprocess.Popen("yum --enablerepo=ius -y install "+" ".join(self.mysql55_rpms), shell=True)
		proc.wait()
		if proc.returncode != 0:
			print "It seems that you don't have the IUS repo installed?. I told you to check that... :/"
			print "Re-installing MySQL 5.0..."
			proc = subprocess.Popen("yum -y install "+" ".join(self.mysql50_rpms), shell=True)
			proc.wait()
			if proc.returncode != 0:
				raise Exception("Mmh... now you're f****d. No MySQL installed o.O")
			raise Exception("Had to stop. Enable IUS repo and try again.")
	
	def upgradeDB(self):
		print "Upgrading databases..."
		proc = subprocess.Popen("/etc/init.d/mysqld start", shell=True)
		proc.wait()
		if proc.returncode != 0:
			raise Exception("Ups. could not start new MySQL server. That's not good :(")
		print "if asked for a password, enter the mysql root password"
		proc = subprocess.Popen("mysql_upgrade -p --force", shell=True)
		proc.wait()
		if proc.returncode != 0:
			raise Exception("Ups. The database upgrade could not be done. :(")
		proc = subprocess.Popen("/etc/init.d/mysqld stop", shell=True)
		proc.wait()
		if proc.returncode != 0:
			raise Exception("Ups. could not stop new MySQL server.")
	
	def relinkAppInit(self):
		shutil.move("/etc/init.d/mysqld", "/etc/init.d/mysqld55")
		os.symlink("/etc/init.d/mysqld_app_init", "/etc/init.d/mysqld")
	
	def startNewMySQL(self):
		print "CONGRATULATIONS!!! YOU MADE IT!"
		print "Thanks for using my script :)"
		txt = "A few more things:\n"
		txt += "* DO NOT FORGET to change ensim's virtual filelists in /etc/virtualhosting/filelists/mysql.sh, "
		txt += "otherwise you get a surprise when running maintenance mode. Replace all lines containing mysql and "
		txt += "mysql-server with mysql55 and mysql55-server. Also add the mysql55-libs and mysqlclient15 package.\n"
		txt += "* The relinked /etc/init.d/mysqld_app_init still may contain parameters like --skip-innodb and --skip-bdb "
		txt += "I suggest you remove these parameters before launching MySQL5.5"
		print txt
	
	def run(self):
		self.notifyUser()
		self.backupNeededFiles()
		self.stopMysql()
		self.removeMysql50()
		self.installMysql55()
		self.loadDatabaseList()
		self.unlinkFiles()
		self.relinkFiles()
		self.upgradeDB()
		self.relinkAppInit()
		self.startNewMySQL()

if __name__ == '__main__':
	script = UpdateMysql()
	try:
		script.run()
	except Exception, e:
		print e
		sys.exit(1)
	sys.exit(0)
