#!/bin/sh

DATE=$(date +%Y%m%d%H%M%S)

echo -n "Turning off quota... "
quotaoff -a
echo "done.";

echo -n "Backing up old files... "
cp /aquota.user /aquota.user.$DATE
cp /aquota.group /aquota.group.$DATE
echo "done."

echo -n "Checking quota... "
quotacheck -ugamn
echo "done."

echo -n "Re-enable quotas... "
quotaon -a
echo "done."

echo "Starting site quota rebuild... "
for SITE in $(sitelookup -a domain)
do
	echo -n "setting "$SITE
	/usr/local/bin/EditVirtDomain $SITE
	echo -n "... "
	echo "done."
done
echo "rebuild done."
