#!/usr/bin/env python

"""
This script uses sftp to connect a pfSense box and extract the
config.xml for backup storage on a local disk
"""

__author__ = "NDK (andy@songoku.homelinux.com)"
__license__ = "BSD"
__version__ = 0.2

try:
	import os
	import sys
	import time
	import shutil
	import re
except ImportError, e:
	print e
	sys.exit(1)

try:
	import pysftp
except ImportError:
	print "PySFTP module not found. Please install it using: easy_install pysftp"
	sys.exit(1)

ssh_host = None
ssh_usr = "root"
ssh_pw = None

num_backup = 3
loc_dir = os.path.expanduser("~")

rem_conf_folder = '/cf/conf/'
rem_conf_file = "config.xml"
rem_config = rem_conf_folder + rem_conf_file

rem_store = False
remote = None

def GetArgValue(arg):
	arg_list = arg.split("=")
	return arg_list[1].strip()

for arg in sys.argv:
	if "--help" in arg:
		print "Script usage:"
		print sys.argv[0] + ":"
		print "	--user=<user>			-> User to connect to ssh server (default: root)"
		print "	--pw=<password>			-> Password used in connection (default: none)"
		print "	--host=<host|ip>		-> Host to connect to (default: none)"
		print "	--dir=<local dir>		-> Local Directory to store (default: user's home folder)"
		print "	--remote=<remote dir>		-> Remote Directory over SFTP"
		print "					e.g. sftp://<user>:<pass>@<server>/<folder>"
		print "					please note that local dir is disabled when used"
		print "	--num=<int number>		-> Number of backups to keep (default: "+num_backup+")"
		sys.exit(1)
	if "--user=" in arg:
		ssh_usr = GetArgValue(arg)
	if "--pw=" in arg:
		ssh_pw = GetArgValue(arg)
	if "--host=" in arg:
		ssh_host = GetArgValue(arg)
	if "--dir=" in arg:
		loc_dir = GetArgValue(arg)
	if "--num=" in arg:
		num_backup = GetArgValue(arg)
	if "--remote=" in arg:
		remote = GetArgValue(arg)
		rem_store = True

try:
	if ssh_pw != None and ssh_host != None:
		os.chdir("/tmp")
		sftp = pysftp.Connection(host=ssh_host, username=ssh_usr, password=ssh_pw)
		sftp.get(rem_config)
		sftp.close()
	else:
		print "Please provide connection details."
		print "Call the script with --help to get more infos"
		sys.exit(1)
except Exception, e:
	print "Oups... something went wrong."
	print "Please check your connection settings or config file location."
	print "Call the script with --help to get more infos"
	sys.exit(1)

fdate = time.strftime("%Y%m%d%H%M%S",time.localtime())
src = "/tmp/"+rem_conf_file
dst_file = "pfsense-"+str(fdate)+"-"+rem_conf_file

if rem_store:
	if not re.search("sftp:\/\/.+:.+@.+\/.+", remote):
		print "Remote parameter is wrong."
		print "Call the script with --help to get more infos"
		sys.exit(1)
	try:
		remote_list = re.split("(:\/\/|@|:|\/)", remote)
		remote_folder = "".join(remote_list[7:])
		sftp = pysftp.Connection(host=remote_list[6], username=remote_list[2], password=remote_list[4])
		sftp.chdir(remote_folder)
		sftp.put(src)
		sftp.execute("mv "+remote_folder+"/"+rem_conf_file+" "+remote_folder+"/"+dst_file)
		os.unlink(src)
	except Exception, e:
		print "Could not move downloaded file to remote server"
		print "Please check your remote connection settings."
		print "Call the script with --help to get more infos"
		print e
		sys.exit(1)

else:
	dst = loc_dir.rstrip("/")+"/"+dst_file
	try:
		shutil.move(src, dst)
	except Exception, e:
		print "Could not move downloaded file"
		print e
		sys.exit(1)

try:
	backup_files = list()
	if remote:
		dirlist = sftp.listdir(remote_folder)
		dirlist.sort()
	else:
		dirlist = os.listdir(loc_dir)
	for f in dirlist:
		if re.search("pfsense-[0-9]{14}-config.xml", f, re.IGNORECASE):
			backup_files.append(f)
	len_bak_files = len(backup_files)
	if len_bak_files > 0 and len_bak_files > num_backup:
		files_to_del = backup_files[0:-num_backup]
		for f in files_to_del:
			if remote:
				sftp.execute("rm -f "+remote_folder+"/"+f)
			else:
				os.unlink(loc_dir.strip()+"/"+f)
	if remote:
		sftp.close()
except Exception, e:
	print "Could not remove older backup files."
	print e

print "Backup done."
sys.exit(0)
