#!/usr/bin/env python

"""
This script set automatically forwards for users. It reads a config file (/etc/autoforwards.conf)
and sets the forwards accordingly. This is a sample line of the config file:

date-from; date-to; domain; user; forward

Please keep in mind that lines containing a hash (#) are excluded and the script is written
for an ensim based red hat or centos box
"""

__author__ = "AndyK"
__license__ = "BSD"
__version__ = 0.1

import os
import sys
import time
import shutil

class ModEmails(object):
	
	def __init__(self):
		self.srcfile = "/etc/autoforwards.conf"
		self.passwd = "/etc/passwd"
		self.emails = list()
	
	def Quit(self, text):
		print text
		sys.exit(1)
	
	def ReadSrcFile(self):
		if not os.path.isfile(self.srcfile):
			self.Quit("Source file " + self.srcfile + " not found")
		for line in open(self.srcfile).readlines():
			line = line.strip()
			if line.find("#") == -1 and line != "":
				line_split = line.split(";")
				line_dict = {
					"from": line_split[0].strip(),
					"to": line_split[1].strip(),
					"domain": line_split[2].strip(),
					"user": line_split[3].strip(),
					"forward": line_split[4].strip(),
					"action": "none"
				}
				self.emails.append(line_dict)
		if len(self.emails) == 0:
			self.Quit("no data in text file. Quitting...")
	
	def GetUserData(self):
		for entry in self.emails:
			pwf = open("/home/virtual/"+entry['domain']+self.passwd).readlines()
			for line in pwf:
				if line.find(entry['user']) != -1:
					line_list = line.strip().split(":")
					entry['uid'] = int(line_list[2])
					entry['gid'] = int(line_list[3])
	
	def CheckDates(self):
		today = time.strftime("%Y-%m-%d", time.gmtime())
		for entry in self.emails:
			if entry['from'] <= today and entry['to'] >= today:
				entry['action'] = "add"
			elif entry['from'] > today:
				pass
			elif entry['to'] < today:
				entry['action'] = "del"
	
	def CheckForwards(self):
		print "---------------------------------------------"
		for entry in self.emails:
			if entry['action'] == "none":
				continue
			fwd_file = "/home/virtual/"+entry['domain']+"/home/"+entry['user']+"/.forward"
			if not os.path.isfile(fwd_file):
				continue
			fcontent = open(fwd_file).read()
			if entry['forward'] in fcontent and entry['action'] == "add":
				print "user '"+entry['user']+"@"+entry['domain']+"': forward already exists."
				entry['action'] = "none"
			elif entry['forward'] not in fcontent and entry['action'] == "del":
				print "user '"+entry['user']+"@"+entry['domain']+"': forward not found."
				fwd_bak = "/home/virtual/"+entry['domain']+"/home/"+entry['user']+"/.forward.autodis"
				if os.path.isfile(fwd_bak):
					os.remove(fwd_bak)
				entry['action'] = "none"
	
	def ModForwards(self):
		print "---------------------------------------------"
		for entry in self.emails:
			if entry['action'] == "none":
				print "user '"+entry['user']+"@"+entry['domain']+"': nothing to do. Skipping..."
				continue
			fwd_file = "/home/virtual/"+entry['domain']+"/home/"+entry['user']+"/.forward"
			fwd_bak = "/home/virtual/"+entry['domain']+"/home/"+entry['user']+"/.forward.autodis"
			if entry['action'] == "add":
				sys.stdout.write("user '"+entry['user']+"@"+entry['domain']+"': adding forward. ")
				if not os.path.isfile(fwd_file):
					f_fwd = open(fwd_file, "w")
					f_fwd.write(entry['forward'])
					f_fwd.close()
					f_bak = open(fwd_bak, "w")
					f_bak.write("")
					f_bak.close()
				else:
					shutil.copy(fwd_file, fwd_bak)
					os.chown(fwd_file, entry['uid'], entry['gid'])
					os.chown(fwd_bak, entry['uid'], entry['gid'])
					f_fwd = open(fwd_file, "w")
					f_fwd.write(entry['forward'])
					f_fwd.close()
				sys.stdout.write("Done.\n")
			elif entry['action'] == "del":
				if not os.path.isfile(fwd_bak):
					fbak = open(fwd_bak, "w")
					fbak.write("")
					fbak.close()
				shutil.copy(fwd_bak, fwd_file)
				os.remove(fwd_bak)
	
	def Main(self):
		self.ReadSrcFile()
		self.GetUserData()
		self.CheckDates()
		self.CheckForwards()
		self.ModForwards()

script = ModEmails()
script.Main()
sys.exit(0)